
<div id="printable-container">
    <div class="app-page-title">
        <div class="page-title-wrapper">
            <div class="page-title-heading">
                <div class="page-title-icon">
                    <i class="pe-7s-notebook text-success"></i>
                </div>
                <?php echo l('Gross & Net Report', true); ?>
            </div>
        </div>
    </div>
    
    <div class="main-card card">
        <div class="card-body">
            <div class="panel panel-default hidden-print">
                <div class="panel-body h4">
                    <div class="form-inline">
                        <?php 
                        $states = Array(
                            "-1" => "All",
                            '0' => "Confirmed",
                            '1' => "In-House",
                            '2' => "Checked-out",
                            '3' => "Out of Order",
                            '4' => "Cancelled",
                            "5" => "No Show",
                            '6' => "Deleted",
                            '7' => "Unconfirmed",
                            '10' => "Departure",
                            '11' => "Arrivals"
                        ); ?>
                        
                    <?php echo l('Bookings for', true); ?>
                    <input type="text" name="date" value="<?php echo $date; ?>" class="form-control date" style="width: 100px;">
                    
                    <button id="printReportButton" class="btn btn-primary pull-right hidden-print"><span class="glyphicon glyphicon-print" title="Print Report"></span></button>
                    &nbsp;&nbsp;
                    <?php $date = ($this->uri->segment(3) != '') ? $this->uri->segment(3) : ""; ?>    
                    <?php $param = $date;  ?>   
                    <a href="<?php if($param != '//'){ echo base_url()."report/download_gross_net_csv_export/".$param; } else { echo base_url()."report/download_gross_net_csv_export/"; } ?>" class="btn btn-primary pull-right " style="margin-right: 10px;">
                        <span title="Export to CSV" class="glyphicon glyphicon-download-alt"></span>
                    </a>&nbsp;&nbsp;
                </div><!-- /.form-inline -->
            </div>
        </div>

        <div class="wep">
         <!-- <div class="h3 col-lg-3"><?=$hotel_name;?></div> -->

        <?php $guest_count = 0; 
            foreach ($bookings as $booking) {
                if($booking['customer_name']) {
                    $guest_count++;
                }
            }
        ?>

        <div style="float: left; margin: 0 18px;">
            <b><?php echo "Total Guests = ".$guest_count; ?></b>
        </div>

         <div class="h3" style="font-size: 20px;">
            <span class="visible-print">
                <b><?php echo l('reporting_period'); ?></b> : <?=date('M d, Y', strtotime($date));?><br>
            </span>
            <span class="visible-print"><b><?php echo l('report_date'); ?></b> : <?=date('M d, Y', strtotime(date('Y-m-d')));?></span>
        </div>
    </div>
    
    <div class="col-lg-12 table-responsive">
        <table id="reservation_table" class="table table-hover table-condensed reservation_table ">
            <thead>
                <tr>
                    <th name="booking_id" class="booking_id"><?php echo l('Reservation Id', true); ?></th>
                    <!-- <th name="room" style="min-width: 100px;"  class="text-left room"><?php echo l('Room'); ?></th>
                    <th name="room_type" style="min-width: 100px;"  class="text-left room_type"><?php echo l('Room Type'); ?></th> -->
                    <th style="min-width: 100px;"  class="text-left customer_name"><?php echo l('guest_name'); ?></th>
                    <th style="min-width: 100px;" class="text-left charge_sub_total"><?php echo l('charge_sub_total'); ?></th>
                    <th style="min-width: 100px;" class="text-left charge_tax_total"><?php echo l('charge_tax_total'); ?></th>
                    <th style="min-width: 100px;" class="text-left charge_final_total"><?php echo l('grand_total'); ?></th>
                    <!-- <th style="min-width: 100px;" class="text-left payment_method"><?php echo l('payment_method'); ?></th> -->
                    <!-- <th name="status" class="text-left status"><?php echo l('status'); ?></th> -->
                
            </tr>
        </thead>
        <tbody>
            <?php

            foreach ($bookings as $booking): ?>
                <tr class='booking' data-booking-id='<?php echo $booking['booking_id']; ?>'>
                    
                    <td class="booking_id">
                        <?php
                        echo $booking['booking_id'];
                        ?>
                    </td>

                    <td class="customer_name">
                        <?php
                        echo $booking['customer_name'];
                        ?>
                    </td>

                    <td class="charge_sub_total">
                        <?php
                        echo  $booking['charge_sub_total'];
                        ?>
                    </td>
                    <td class="charge_tax_total">
                        <?php
                        echo  $booking['charge_tax_total'];
                        ?>
                    </td>
                    <td class="charge_final_total">
                        <?php
                        echo  $booking['charge_final_total'];
                        ?>
                    </td>
                    
                    <!-- <td class="room">
                        <?php
                        echo $booking['room_name'];
                        ?>
                    </td>
                    <td class="room_type">
                        <?php
                        echo $booking['room_type_name'];
                        ?>
                    </td> -->
                    
                    <!-- <td class="status">
                        <?php
                            echo $states[$booking['state']];
                        ?>
                    </td> -->
                    
                </tr>
                <?php
            endforeach;
            ?>
        </tbody>

    </table>
    
</div>
</div>
</div>
</div>
<?php $flag = 1;
$permissions = $this->session->userdata('permissions');
if ($permissions && in_array('bookings_view_only', $permissions) && !(in_array('access_to_bookings', $permissions))) {
    $flag = 0;
}
?>
<input type="hidden" name="flag" value="<?php echo $flag; ?>" >


